/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.model.IServer;
import com.jrockit.mc.rjmx.model.IServerModel;
import com.jrockit.mc.rjmx.model.internal.ServerModel;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.internal.ExtensionMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.internal.FileMRIMetaDataDB;
import com.jrockit.mc.rjmx.triggers.extension.internal.TriggerFactory;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.rjmx.util.internal.XmlSerializerToolkit;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;

public final class RJMXSingleton {
    private static final String PREFERENCE_ATTRIBUTE_META_DATA_MANAGER = "AttributeMetaDataManager";
    private static final String SERVER_MODEL_PREF = "server_model";
    private static final String TRIGGERS_MODEL_PREF = "triggers_model";
    private static final RJMXSingleton INSTANCE = new RJMXSingleton();
    private final FileMRIMetaDataDB metaDataManager = new FileMRIMetaDataDB();
    private final IMRIMetaDataProviderService metaDataProviderService = new ExtensionMetaDataProviderService();
    private final NotificationRegistry notificationModel = new NotificationRegistry();
    private final ServerModel serverModel = new ServerModel();

    private RJMXSingleton() {
        TriggerFactory tf = new TriggerFactory(this.notificationModel);
        tf.initializeFactory();
        this.notificationModel.setFactory(tf);
        this.initAllSettings();
        try {
            this.cleanServerPreferences();
        }
        catch (BackingStoreException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to clean server preferences", e);
        }
    }

    private void initAllSettings() {
        Document doc;
        XmlSerializerToolkit.importFromRJMXPreferences(this.metaDataManager, PREFERENCE_ATTRIBUTE_META_DATA_MANAGER);
        try {
            doc = XmlToolkit.loadDocumentFromString((String)this.getRJMXPreferences().get(SERVER_MODEL_PREF, null));
            this.serverModel.importServers(doc);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load server model from preferences", e);
        }
        try {
            doc = XmlToolkit.loadDocumentFromString((String)this.getRJMXPreferences().get(TRIGGERS_MODEL_PREF, null));
            this.notificationModel.importFromXML(doc);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load notification model from preferences", e);
        }
    }

    void storeAllSettings() throws Exception {
        XmlSerializerToolkit.exportToRJMXPreferences(this.metaDataManager, PREFERENCE_ATTRIBUTE_META_DATA_MANAGER);
        this.getRJMXPreferences().put(SERVER_MODEL_PREF, XmlToolkit.storeDocumentToString((Document)this.serverModel.exportServers(new IServer[0])));
        this.getRJMXPreferences().put(TRIGGERS_MODEL_PREF, XmlToolkit.storeDocumentToString((Document)this.notificationModel.exportToXml(null, true)));
        this.getRJMXPreferences().flush();
    }

    private void cleanServerPreferences() throws BackingStoreException {
        HashSet<String> serverIds = new HashSet<String>();
        IServer[] iServerArray = this.serverModel.elements();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            serverIds.add(server.getServerHandle().getServerDescriptor().getGUID());
            ++n2;
        }
        Preferences serverPrefs = this.getRJMXPreferences().node("serverConfig");
        String[] stringArray = serverPrefs.childrenNames();
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String serverId = stringArray[n];
            if (!serverIds.contains(serverId)) {
                serverPrefs.node(serverId).removeNode();
            }
            ++n;
        }
    }

    public static RJMXSingleton getDefault() {
        return INSTANCE;
    }

    private IEclipsePreferences getRJMXPreferences() {
        return RJMXPlugin.getDefault().getRJMXPreferences();
    }

    public <T> T getService(Class<T> clazz) {
        if (clazz == NotificationRegistry.class) {
            return (T)this.notificationModel;
        }
        if (clazz == IMRIMetaDataService.class) {
            return (T)this.metaDataManager;
        }
        if (clazz == IMRIMetaDataProviderService.class) {
            return (T)this.metaDataProviderService;
        }
        if (clazz == IServerModel.class) {
            return (T)this.serverModel;
        }
        if (clazz == ServerModel.class) {
            return (T)this.serverModel;
        }
        return null;
    }
}

