/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.preferences;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.ui.misc.QuantityKindProposal;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class LongQuantityFieldEditor<Q extends IQuantity>
extends StringFieldEditor {
    private KindOfQuantity<Q> type;
    private IUnit<Q> storageUnit;
    private Q min;
    private Q max;

    public LongQuantityFieldEditor(String name, String labelText, Composite parent, KindOfQuantity<Q> type, IUnit<Q> storageUnit) {
        this.type = type;
        this.storageUnit = storageUnit;
        this.init(name, labelText);
        this.createControl(parent);
        QuantityKindProposal.install(this.getTextControl(), type);
    }

    public void setValidRange(Q min, Q max) {
        this.min = min;
        this.max = max;
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String quantityString = text.getText();
        try {
            IQuantity quantity = this.type.parseInteractive(quantityString);
            if (this.min != null && this.min.compareTo((Object)quantity) > 0) {
                throw QuantityConversionException.tooLow((IQuantity)quantity, this.min);
            }
            if (this.max != null && this.max.compareTo((Object)quantity) < 0) {
                throw QuantityConversionException.tooHigh((IQuantity)quantity, this.max);
            }
            this.clearErrorMessage();
            return true;
        }
        catch (QuantityConversionException e) {
            this.showErrorMessage(e.getLocalizedMessage());
            return false;
        }
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            IQuantity value = this.storageUnit.quantity(this.getPreferenceStore().getLong(this.getPreferenceName()));
            text.setText(value.interactiveFormat());
            this.oldValue = value.interactiveFormat();
        }
        this.valueChanged();
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            IQuantity value = this.storageUnit.quantity(this.getPreferenceStore().getLong(this.getPreferenceName()));
            text.setText(value.interactiveFormat());
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        try {
            if (text != null) {
                IQuantity value = this.type.parseInteractive(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.in(this.storageUnit).longValue());
            }
        }
        catch (QuantityConversionException quantityConversionException) {
            // empty catch block
        }
    }
}

