/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.ReconnectDecorator;
import org.netbeans.api.visual.action.ReconnectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class ReconnectAction
extends WidgetAction.LockedAdapter {
    private static final int MIN_DIFFERENCE = 5;
    private ReconnectDecorator decorator;
    private ReconnectProvider provider;
    private ConnectionWidget connectionWidget = null;
    private boolean reconnectingSource = false;
    private Point floatPoint = null;
    private Widget replacementWidget = null;
    private Anchor originalAnchor = null;

    public ReconnectAction(ReconnectDecorator reconnectDecorator, ReconnectProvider reconnectProvider) {
        this.decorator = reconnectDecorator;
        this.provider = reconnectProvider;
    }

    @Override
    protected boolean isLocked() {
        return this.connectionWidget != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1 && widget instanceof ConnectionWidget) {
            ConnectionWidget connectionWidget = (ConnectionWidget)widget;
            int n = connectionWidget.getControlPointHitAt(widgetMouseEvent.getPoint());
            List<Point> list = connectionWidget.getControlPoints();
            if (n == 0 && this.provider.isSourceReconnectable(connectionWidget)) {
                this.reconnectingSource = true;
            } else if (list != null && n == list.size() - 1 && this.provider.isTargetReconnectable(connectionWidget)) {
                this.reconnectingSource = false;
            } else {
                return WidgetAction.State.REJECTED;
            }
            this.floatPoint = new Point(widgetMouseEvent.getPoint());
            this.replacementWidget = null;
            this.connectionWidget = connectionWidget;
            this.provider.reconnectingStarted(connectionWidget, this.reconnectingSource);
            this.originalAnchor = this.reconnectingSource ? this.connectionWidget.getSourceAnchor() : this.connectionWidget.getTargetAnchor();
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        Point point = widgetMouseEvent.getPoint();
        boolean bl = this.move(widget, point);
        if (bl) {
            this.cancel(point);
        }
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    private void cancel(Point point) {
        if (this.reconnectingSource) {
            this.connectionWidget.setSourceAnchor(this.originalAnchor);
        } else {
            this.connectionWidget.setTargetAnchor(this.originalAnchor);
        }
        this.provider.reconnectingFinished(this.connectionWidget, this.reconnectingSource);
        if (point != null && (Math.abs(this.floatPoint.x - point.x) >= 5 || Math.abs(this.floatPoint.y - point.y) >= 5)) {
            this.provider.reconnect(this.connectionWidget, this.replacementWidget, this.reconnectingSource);
        }
        this.replacementWidget = null;
        this.floatPoint = null;
        this.connectionWidget = null;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.connectionWidget != widget) {
            return false;
        }
        Point point2 = widget.convertLocalToScene(point);
        this.replacementWidget = this.resolveReplacementWidgetCore(this.connectionWidget.getScene(), point2);
        Anchor anchor = null;
        if (this.replacementWidget != null) {
            anchor = this.decorator.createReplacementWidgetAnchor(this.replacementWidget);
        }
        if (anchor == null) {
            anchor = this.decorator.createFloatAnchor(point2);
        }
        if (this.reconnectingSource) {
            this.connectionWidget.setSourceAnchor(anchor);
        } else {
            this.connectionWidget.setTargetAnchor(anchor);
        }
        return true;
    }

    protected Widget resolveReplacementWidgetCore(Scene scene, Point point) {
        if (this.provider != null && this.provider.hasCustomReplacementWidgetResolver(scene)) {
            return this.provider.resolveReplacementWidget(scene, point);
        }
        Point point2 = scene.getLocation();
        point = new Point(point.x + point2.x, point.y + point2.y);
        Widget[] widgetArray = new Widget[]{null};
        this.resolveReplacementWidgetCoreDive(widgetArray, scene, point);
        return widgetArray[0];
    }

    private boolean resolveReplacementWidgetCoreDive(Widget[] widgetArray, Widget widget, Point point) {
        if (widget == this.connectionWidget) {
            return false;
        }
        Point point2 = widget.getLocation();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        if (!widget.getBounds().contains(point3)) {
            return false;
        }
        List<Widget> list = widget.getChildren();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!this.resolveReplacementWidgetCoreDive(widgetArray, list.get(i), point3)) continue;
            return true;
        }
        if (!widget.isHitAt(point3)) {
            return false;
        }
        ConnectorState connectorState = this.provider.isReplacementWidget(this.connectionWidget, widget, this.reconnectingSource);
        if (connectorState == ConnectorState.REJECT) {
            return false;
        }
        if (connectorState == ConnectorState.ACCEPT) {
            widgetArray[0] = widget;
        }
        return true;
    }

    @Override
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        if (this.isLocked() && widgetKeyEvent.getKeyCode() == 27) {
            this.cancel(null);
            return WidgetAction.State.CONSUMED;
        }
        return super.keyPressed(widget, widgetKeyEvent);
    }
}

