/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPageService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.SlavePageService;
import org.eclipse.ui.internal.SlavePartService;
import org.eclipse.ui.internal.SlaveSelectionService;
import org.eclipse.ui.internal.WindowSelectionService;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;

public class WorkbenchSupportFactory
extends AbstractServiceFactory {
    @Override
    public Object create(Class serviceInterface, IServiceLocator parentLocator, IServiceLocator locator) {
        IWorkbenchLocationService wls = (IWorkbenchLocationService)locator.getService(IWorkbenchLocationService.class);
        IWorkbench wb = wls.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        IWorkbenchPartSite site = wls.getPartSite();
        Object parent = parentLocator.getService(serviceInterface);
        if (parent == null) {
            if (IProgressService.class.equals((Object)serviceInterface)) {
                return wb.getProgressService();
            }
            if (IWorkbenchSiteProgressService.class.equals((Object)serviceInterface) && site instanceof PartSite) {
                return ((PartSite)site).getSiteProgressService();
            }
            if (IPartService.class.equals((Object)serviceInterface) && window != null) {
                return window.getPartService();
            }
            if (IPageService.class.equals((Object)serviceInterface) && window != null) {
                return window;
            }
            if (ISelectionService.class.equals((Object)serviceInterface) && window != null) {
                return window.getSelectionService();
            }
            return null;
        }
        if (ISelectionService.class.equals((Object)serviceInterface)) {
            if (parent instanceof WindowSelectionService && window != null && window.getActivePage() != null) {
                return new SlaveSelectionService(window.getActivePage());
            }
            return new SlaveSelectionService((ISelectionService)parent);
        }
        if (IProgressService.class.equals((Object)serviceInterface) && site instanceof PartSite) {
            return ((PartSite)site).getSiteProgressService();
        }
        if (IPartService.class.equals((Object)serviceInterface)) {
            return new SlavePartService((IPartService)parent);
        }
        if (IPageService.class.equals((Object)serviceInterface)) {
            return new SlavePageService((IPageService)parent);
        }
        return null;
    }
}

