/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ThreadGroupEntry
extends VMObject {
    private static Field threadGroupIDField;
    private static Field parentGroupIDField;
    private static AddressField threadGroupNameField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ThreadGroupIDs::ThreadGroupEntry");
        threadGroupIDField = type.getField("_thread_group_id");
        parentGroupIDField = type.getField("_parent_group_id");
        threadGroupNameField = type.getAddressField("_thread_group_name");
    }

    public ThreadGroupEntry(Address addr) {
        super(addr);
    }

    public int threadGroupID() {
        return threadGroupIDField.getJInt(this.addr);
    }

    public int parentGID() {
        return parentGroupIDField.getJInt(this.addr);
    }

    public String threadGroupName() {
        Address tgNameAddress = threadGroupNameField.getValue(this.addr);
        if (tgNameAddress == null) {
            return null;
        }
        StringBuffer tgName = new StringBuffer();
        int i = 0;
        char c = (char)tgNameAddress.getJByteAt(i);
        while (c != '\u0000') {
            tgName.append(c);
            c = (char)tgNameAddress.getJByteAt(++i);
        }
        return new String(tgName);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ThreadGroupEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

