/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.celleditors;

import com.jrockit.mc.rjmx.ui.celleditors.NumberCellEditor;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import java.lang.reflect.Array;
import org.eclipse.swt.widgets.Composite;

public class ArrayLengthCellEditor
extends NumberCellEditor<Integer> {
    private final Class<?> arrayType;
    private Object oldArray;

    public ArrayLengthCellEditor(Composite parent, Class<?> arrayType) {
        super(parent, Integer.class, true, false);
        this.arrayType = arrayType;
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType + " is not an array type");
        }
    }

    @Override
    protected void doSetValue(Object value) {
        this.oldArray = value;
        if (value == null) {
            super.doSetValue(null);
        } else if (this.arrayType.isAssignableFrom(value.getClass())) {
            super.doSetValue(Array.getLength(value));
        }
    }

    @Override
    protected Object doGetValue() {
        Object newLength = super.doGetValue();
        if (!(newLength instanceof Integer)) {
            return null;
        }
        if (this.oldArray != null && newLength.equals(Array.getLength(this.oldArray))) {
            return this.oldArray;
        }
        return Array.newInstance(this.arrayType.getComponentType(), (int)((Integer)newLength));
    }

    @Override
    protected String getInfoText() {
        return String.valueOf(Messages.ArrayLengthCellEditor_ENTER_THE_LENGTH_OF_THE_ARRAY) + "\n" + super.getInfoText();
    }
}

