/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilter;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilterFactory;
import com.jrockit.mc.flightrecorder.ui.filtering.FilterPart;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.misc.DoubleFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;

public class ThresholdFilterPart
extends FilterPart {
    private DoubleFieldEditor m_thresholdEditor;

    protected ThresholdFilterPart() {
        super(Messages.PREFILTER_WIZARD_THRESHOLD_FILTER_NAME_TEXT, Messages.PREFILTER_WIZARD_THRESHOLD_DESCRIPTION_TEXT, 1);
    }

    protected void createFieldEditors() {
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.horizontalSpan = 2;
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText(this.getDescription());
        label.setLayoutData((Object)gd1);
        this.m_thresholdEditor = new DoubleFieldEditor("threshold", Messages.PREFILTER_WIZARD_THRESHOLD_LABEL_TEXT, this.getFieldEditorParent());
        this.m_thresholdEditor.setValidRange(1.0E-6, 1.0E9);
        this.m_thresholdEditor.setStringValue("20");
        this.m_thresholdEditor.setPage((DialogPage)this);
        this.addField((FieldEditor)this.m_thresholdEditor);
    }

    @Override
    public EventFilter createFilter() {
        if (this.m_thresholdEditor.isValid()) {
            return EventFilterFactory.createThresholdFilter((long)(this.m_thresholdEditor.getDoubleValue() * 1000.0 * 1000.0));
        }
        return null;
    }

    @Override
    public Image getImage() {
        return FlightRecorderUI.getDefault().getImage("time-span-16.png");
    }
}

