/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.RAFFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class MemoryRAFFile
extends RAFFile {
    private URL url;
    private byte[] data;
    private int size;
    private int filePointer;
    private static boolean debugFlag = false;

    public MemoryRAFFile(URLConnection uRLConnection) throws IOException {
        this.url = uRLConnection.getURL();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.data = byteArrayOutputStream.toByteArray();
        this.size = byteArrayOutputStream.size();
        this.filePointer = 0;
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.filePointer = 0;
        this.data = null;
        this.size = 0;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long l) throws IOException {
        if (l > (long)this.size) {
            throw new IOException();
        }
        this.filePointer = (int)l;
    }

    @Override
    public int read() throws IOException {
        if (this.filePointer >= this.size) {
            return -1;
        }
        ++this.filePointer;
        return this.data[this.filePointer - 1] & 0xFF;
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        MemoryRAFFile.debug("readBytes");
        if (this.filePointer + n + n2 > this.size) {
            throw new IOException();
        }
        this.filePointer += n;
        System.arraycopy(this.data, this.filePointer, byArray, 0, n2);
        this.filePointer += n2;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        MemoryRAFFile.debug("readInt");
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        if ((n | n2 | n3 | n4) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    @Override
    public void writeInt(int n) throws IOException {
        throw new IOException("Unsupported Operation");
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        throw new IOException("Unsupported Operation");
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("MemoryRAFFile: " + string);
        }
    }
}

